%------------------------------------------------------------------------------
% File     : SYO558^1 : TPTP v7.4.0. Released v5.2.0.
% Domain   : Syntactic
% Problem  : Forall on $i can be expressed in terms of choice on $
% Version  : Especial.
% English  :

% Refs     : [Bro11] Brown (2011), Email to Geoff Sutcliffe
% Source   : [Bro11]
% Names    : CHOICE30 [Bro11]

% Status   : Theorem
% Rating   : 0.57 v7.4.0, 0.33 v7.2.0, 0.25 v7.1.0, 0.38 v7.0.0, 0.29 v6.4.0, 0.33 v6.3.0, 0.40 v6.2.0, 0.57 v6.1.0, 0.43 v5.5.0, 0.50 v5.4.0, 0.80 v5.2.0
% Syntax   : Number of formulae    :    3 (   0 unit;   1 type;   0 defn)
%            Number of atoms       :   11 (   1 equality;   8 variable)
%            Maximal formula depth :    8 (   6 average)
%            Number of connectives :    9 (   1   ~;   0   |;   0   &;   6   @)
%                                         (   0 <=>;   1  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    5 (   5   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    3 (   1   :;   0   =)
%            Number of variables   :    5 (   0 sgn;   1   !;   1   ?;   3   ^)
%                                         (   5   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : (eps (complement P)) can only satisfy P if everything satisfies P.
%            Hence (^P.P(eps (^x.~Px))) = (^P.!! P).
%          : Note that this problem uses !! for forall instead of the ! 
%            quantifier.
%------------------------------------------------------------------------------
thf(eps,type,(
    eps: ( $i > $o ) > $i )).

thf(choiceax,axiom,(
    ! [P: $i > $o] :
      ( ? [X: $i] :
          ( P @ X )
     => ( P @ ( eps @ P ) ) ) )).

thf(conj,conjecture,
    ( ( ^ [P: $i > $o] :
          ( P
          @ ( eps
            @ ^ [X: $i] :
                ~ ( P @ X ) ) ) )
    = ( ^ [P: $i > $o] :
          !! ( P ) ) )).

%------------------------------------------------------------------------------
